import React from 'react';
import { View } from 'react-native';
import { FontAwesome } from '@expo/vector-icons';

const StarsDisplay = ({ styles, count }) => {

  
  return (
    <View style={styles.starsContainer}>
      {[...Array(5)].map((_, index) => (
        <FontAwesome
          key={index}
          name={index < count  ? 'star' : 'star-o'}
          size={24}
          color={index < count  ? 'gold' : 'black'}
        />
      ))}
    </View>
  );
};

export default StarsDisplay;
