import React from 'react';
import { View, Text, FlatList, TouchableOpacity, StyleSheet } from 'react-native';
import { MaterialIcons } from '@expo/vector-icons';

const ActivityList = ({ activities, removeActivity }) => {
  return (
    <FlatList
      data={activities}
      keyExtractor={(item, index) => index.toString()}
      renderItem={({ item, index }) => (
        <View style={styles.activityItem}>
          <Text>
            {item.type} - Wert: {item.value.toFixed(2)}
          </Text>
          <TouchableOpacity onPress={() => removeActivity(index)}>
            <MaterialIcons name="delete-forever" size={24} color="black" />
          </TouchableOpacity>
        </View>
      )}
      contentContainerStyle={{ padding: 10 }}
      style={{ maxHeight: 200 }} // Begrenzte Höhe für die Liste
    />
  );
};

const styles = StyleSheet.create({
  activityItem: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    paddingHorizontal: 20,
    paddingVertical: 10,
    backgroundColor: 'white',
    marginVertical: 5,
    elevation: 1,
    borderRadius: 5,
  },
});

export default ActivityList;
