import React, { useState } from 'react';
import { SafeAreaView, Text } from 'react-native';
import DateNavigation from './components/DateNavigation';
import StarsDisplay from './components/StarsDisplay';
import MapPlaceholder from './components/MapPlaceholder';
import InfoDisplay from './components/InfoDisplay';
import Activities from './components/Activities';
import RecordingButton from './components/RecordingButton';
import AddActivityModal from './components/AddActivityModal';
import ActivityList from './components/ActivityList';

import styles from './styles';

const App = () => {
  const [currentDate, setCurrentDate] = useState(new Date());
  const [isRecording, setIsRecording] = useState(false);
  const [isModalVisible, setIsModalVisible] = useState(false);
  const [selectedActivity, setSelectedActivity] = useState(null);
  const [activityLog, setActivityLog] = useState([]);

  const starCount = Math.min(activityLog.length, 5);

  const predefinedActivities = [
    { type: 'Joggen' },
    { type: 'Radfahren' },
    { type: 'Spazieren' },
  ];

  const toggleRecording = () => {
    setIsRecording((prev) => !prev);
  };

  const openModal = () => {
    setIsModalVisible(true);
  };

  const handleSelectActivity = (activity) => {
    setActivityLog((prev) => [...prev, { ...activity, value: 0 }]);
    setIsModalVisible(false);
  };

  return (
    <SafeAreaView style={styles.container}>
      <DateNavigation
        currentDate={currentDate}
        setCurrentDate={setCurrentDate}
        styles={styles}
      />
      <StarsDisplay styles={styles} count={starCount} />

      <MapPlaceholder styles={styles} />
      {selectedActivity && (
        <Text style={{ textAlign: 'center', fontSize: 16, margin: 10 }}>
          Gewählte Aktivität: {selectedActivity.type}
        </Text>
      )}

      <InfoDisplay styles={styles} />
      <Activities styles={styles} openModal={openModal} />
      <ActivityList
        activities={activityLog}
        removeActivity={(index) =>
          setActivityLog((prev) => prev.filter((_, i) => i !== index))
        }
      />

      <RecordingButton
        isRecording={isRecording}
        toggleRecording={toggleRecording}
        styles={styles}
      />
      <AddActivityModal
        visible={isModalVisible}
        predefinedActivities={predefinedActivities}
        onSelectActivity={handleSelectActivity}
        onClose={() => setIsModalVisible(false)}
      />
    </SafeAreaView>
  );
};

export default App;
