import React from 'react';
import { View, Text, TouchableOpacity } from 'react-native';
import { MaterialIcons } from '@expo/vector-icons';

const DateNavigation = ({ currentDate, setCurrentDate, styles }) => {
  const changeDate = (direction) => {
    setCurrentDate((prevDate) => {
      const newDate = new Date(prevDate);
      newDate.setDate(prevDate.getDate() + direction);
      return newDate;
    });
  };

  return (
    <View style={styles.dateContainer}>
      <TouchableOpacity onPress={() => changeDate(-1)}>
        <MaterialIcons name="arrow-back-ios" size={24} color="black" />
      </TouchableOpacity>
      <Text style={styles.dateText}>{currentDate.toDateString()}</Text>
      <TouchableOpacity onPress={() => changeDate(1)}>
        <MaterialIcons name="arrow-forward-ios" size={24} color="black" />
      </TouchableOpacity>
    </View>
  );
};

export default DateNavigation;
