import React, { useState } from 'react';
import { SafeAreaView } from 'react-native';
import DateNavigation from './components/DateNavigation';
import StarsDisplay from './components/StarsDisplay';
import MapPlaceholder from './components/MapPlaceholder';
import InfoDisplay from './components/InfoDisplay';
import Activities from './components/Activities';
import RecordingButton from './components/RecordingButton';
import AddActivityModal from './components/AddActivityModal';

import styles from './styles';

const App = () => {
  const [currentDate, setCurrentDate] = useState(new Date());
  const [isRecording, setIsRecording] = useState(false);
  const [isModalVisible, setIsModalVisible] = useState(false);

  const predefinedActivities = [
    { type: 'Joggen' },
    { type: 'Radfahren' },
    { type: 'Spazieren' },
  ];

  const toggleRecording = () => {
    setIsRecording((prev) => !prev);
  };

  const openModal = () => {
    setIsModalVisible(true);
  };

  const handleSelectActivity = (activity) => {
    console.log('Ausgewählte Aktivität:', activity);
    setIsModalVisible(false); // Modal schließen
  };

  return (
    <SafeAreaView style={styles.container}>
      <DateNavigation
        currentDate={currentDate}
        setCurrentDate={setCurrentDate}
        styles={styles}
      />
      <StarsDisplay styles={styles} />
      <MapPlaceholder styles={styles} />
      <InfoDisplay styles={styles} />
      <Activities styles={styles} openModal={openModal} />

      <RecordingButton
        isRecording={isRecording}
        toggleRecording={toggleRecording}
        styles={styles}
      />
      <AddActivityModal
        visible={isModalVisible}
        predefinedActivities={predefinedActivities}
        onSelectActivity={handleSelectActivity}
        onClose={() => setIsModalVisible(false)}
      />
    </SafeAreaView>
  );
};

export default App;
