import React from 'react';
import { View } from 'react-native';
import { FontAwesome } from '@expo/vector-icons';

const StarsDisplay = ({ styles }) => {
  const filledStars = 3; // Beispiel: 3 gefüllte Sterne
  return (
    <View style={styles.starsContainer}>
      {[...Array(5)].map((_, index) => (
        <FontAwesome
          key={index}
          name={index < filledStars ? 'star' : 'star-o'}
          size={24}
          color={index < filledStars ? 'gold' : 'black'}
        />
      ))}
    </View>
  );
};

export default StarsDisplay;
