import React, { useState } from 'react';
import { SafeAreaView } from 'react-native';
import DateNavigation from './components/DateNavigation';
import StarsDisplay from './components/StarsDisplay';
import MapPlaceholder from './components/MapPlaceholder';
import InfoDisplay from './components/InfoDisplay';
import Activities from './components/Activities';
import RecordingButton from './components/RecordingButton';
import styles from './styles';

const App = () => {
  const [currentDate, setCurrentDate] = useState(new Date());
  const [isRecording, setIsRecording] = useState(false);

  const toggleRecording = () => {
    setIsRecording((prev) => !prev);
  };

  return (
    <SafeAreaView style={styles.container}>
      <DateNavigation
        currentDate={currentDate}
        setCurrentDate={setCurrentDate}
        styles={styles}
      />
      <StarsDisplay styles={styles} />
      <MapPlaceholder styles={styles} />
      <InfoDisplay styles={styles} />
      <Activities styles={styles} />
      <RecordingButton
        isRecording={isRecording}
        toggleRecording={toggleRecording}
        styles={styles}
      />
    </SafeAreaView>
  );
};

export default App;
