import React from 'react';
import { View, Text, Button } from 'react-native';
import { styles } from '../styles';

export default function ErgebnisScreen({ maxWert, onRestart, bewegungen }) {
  const bewertung = (wert) => {
    if (wert < 1.5) return 'Zaghafter Hopser 😅';
    if (wert < 2.2) return 'Solider Sprung 💪';
    return 'Wow! Rakete! 🚀';
  };

  return (
    <View style={{ alignItems: 'center' }}>
      <Text style={styles.resultText}>Dein Wert: {maxWert.toFixed(2)} g</Text>
      <Text style={styles.feedback}>{bewertung(maxWert)}</Text>
      <Button title="Nochmal springen" onPress={onRestart} />
      <View style={{ marginTop: 20 }}>
        <Text style={styles.resultText}>📊 Bewegungsliste:</Text>
        {bewegungen.slice(-100).map((wert, index) => (
          <Text key={index}>
            {index + 1}: {wert.toFixed(2)} g
          </Text>
        ))}
      </View>
    </View>
  );
}
