import React, { useState, useEffect, useRef, useCallback } from 'react';
import { View, Text } from 'react-native';
import { Accelerometer } from 'expo-sensors';
import { styles } from './styles';

import StartScreen from './components/StartScreen';
import CountdownScreen from './components/CountdownScreen';
import MessungInfo from './components/MessungInfo';
import ErgebnisScreen from './components/ErgebnisScreen';

export default function App() {
  const [status, setStatus] = useState('idle'); // idle, countdown, measuring, result
  const [countdown, setCountdown] = useState(3);
  const [maxWert, setMaxWert] = useState(0);
  const [bewegungen, setBewegungen] = useState([]);

  const intervalRef = useRef(null);
  const sensorRef = useRef(null);

  const startChallenge = () => {
    setStatus('countdown');
    setCountdown(3);
    setMaxWert(0);
  };

  const startMessung = useCallback(() => {
    setBewegungen([]);
    setStatus('measuring');
    setMaxWert(0);
    Accelerometer.setUpdateInterval(100);

    sensorRef.current = Accelerometer.addListener(({ x, y, z }) => {
      const bewegung = Math.sqrt(x * x + y * y + z * z);

      // Neuen Wert zum Array hinzufügen (funktionale Variante!)
      setBewegungen((prev) => [...prev, bewegung]);

      // Vergleich OHNE prev:
      if (bewegung > maxWert) {
        setMaxWert(bewegung);
      }
    });

    setTimeout(() => {
      sensorRef.current && sensorRef.current.remove();
      setStatus('result');
    }, 2000); // 2 Sekunden Messung
  }, [maxWert]);

  useEffect(() => {
    if (status === 'countdown') {
      intervalRef.current = setInterval(() => {
        setCountdown((prev) => {
          if (prev === 1) {
            clearInterval(intervalRef.current);
            startMessung();
            return 0;
          }
          return prev - 1;
        });
      }, 1000);
    }
    return () => clearInterval(intervalRef.current);
  }, [status, startMessung]);

  // 👇 Klassische Anzeige-Logik per if
  let currentScreen;
  if (status === 'idle') {
    currentScreen = <StartScreen onStart={startChallenge} />;
  } else if (status === 'countdown') {
    currentScreen = <CountdownScreen countdown={countdown} />;
  } else if (status === 'measuring') {
    currentScreen = <MessungInfo />;
  } else if (status === 'result') {
    currentScreen = (
      <ErgebnisScreen
        maxWert={maxWert}
        onRestart={startChallenge}
        bewegungen={bewegungen}
      />
    );
  }

  return (
    <View style={styles.container}>
      <Text style={styles.title}>🏃‍♂️ Jumpalyze</Text>
      {currentScreen}
    </View>
  );
}
