import React from 'react';
import { View, Text, Button } from 'react-native';
import { styles } from '../styles';

export default function ErgebnisScreen({ maxWert, onRestart }) {
  const bewertung = (wert) => {
    if (wert < 1.5) return 'Zaghafter Hopser 😅';
    if (wert < 2.2) return 'Solider Sprung 💪';
    return 'Wow! Rakete! 🚀';
  };

  return (
    <View style={{ alignItems: 'center' }}>
      <Text style={styles.resultText}>Dein Wert: {maxWert.toFixed(2)} g</Text>
      <Text style={styles.feedback}>{bewertung(maxWert)}</Text>
      <Button title="Nochmal springen" onPress={onRestart} />
    </View>
  );
}
