import React from 'react';
import { View, Text } from 'react-native';
import styles from '../GameStyles';

export default function GameScreen({ position, ziel, punkte, spielBeendet, spielDauer }) {
  return (
    <View style={styles.container}>
      {!spielBeendet && (
        <>
          {/* Zielbereich */}
          <View
            style={[
              styles.ziel,
              { left: ziel.x, top: ziel.y, width: ziel.size, height: ziel.size },
            ]}
          />

          {/* Ball */}
          <View
            style={[
              styles.ball,
              { left: position.x, top: position.y },
            ]}
          />

          {/* Punktestand */}
          <Text style={styles.punkteText}>Punkte: {punkte}</Text>
        </>
      )}

      {spielBeendet && (
        <View style={styles.endTextContainer}>
          <Text style={styles.endText}>🎉 Ziel erreicht!</Text>
          <Text style={styles.endText}>Gesamtdauer: {spielDauer} Sekunden</Text>
        </View>
      )}
    </View>
  );
}
