import React, { useState, useEffect } from 'react';
import { Dimensions } from 'react-native';
import { Accelerometer } from 'expo-sensors';
import GameScreen from './components/GameScreen';

const { width, height } = Dimensions.get('window');

export default function App() {
  const [ziel, setZiel] = useState({
    x: 200,
    y: 400,
    size: 60,
  });

  const [position, setPosition] = useState({
    x: width / 2 - 25,
    y: height / 2 - 25,
  });

  const [punkte, setPunkte] = useState(0);
  const [zielSchonErreicht, setZielSchonErreicht] = useState(false);

  // Neue Zielposition erzeugen
  function neueZielPosition() {
    const randX = Math.random() * (width - 60);
    const randY = Math.random() * (height - 60);
    setZiel({ x: randX, y: randY, size: 60 });
  }

  // Bewegung über Accelerometer
  useEffect(() => {
    const subscription = Accelerometer.addListener(({ x, y }) => {
      setPosition((prev) => {
        let newX = prev.x + x * 30;
        let newY = prev.y + y * -30;

        newX = Math.max(0, Math.min(width - 50, newX));
        newY = Math.max(0, Math.min(height - 50, newY));

        return { x: newX, y: newY };
      });
    });

    Accelerometer.setUpdateInterval(100);
    return () => subscription.remove();
  }, []);

  // Punkt zählen + Ziel neu platzieren
  useEffect(() => {
    const getroffen =
      position.x > ziel.x &&
      position.x < ziel.x + ziel.size &&
      position.y > ziel.y &&
      position.y < ziel.y + ziel.size;

    if (getroffen && !zielSchonErreicht) {
      setPunkte((prev) => prev + 1);
      setZielSchonErreicht(true);
      neueZielPosition();
    } else if (!getroffen) {
      setZielSchonErreicht(false);
    }
  }, [position, ziel, zielSchonErreicht]); 

  return (
    <GameScreen
      position={position}
      ziel={ziel}
      punkte={punkte}
      spielBeendet={false}
      spielDauer={0}
    />
  );
}
