import React, { useState, useEffect } from 'react';
import { Dimensions } from 'react-native';
import { Accelerometer } from 'expo-sensors';
import GameScreen from './components/GameScreen';

const { width, height } = Dimensions.get('window');

export default function App() {
  const ziel = { x: 200, y: 400, size: 60 };

  const [position, setPosition] = useState({
    x: width / 2 - 25,
    y: height / 2 - 25,
  });

  const [punkte, setPunkte] = useState(0);
  const [zielSchonErreicht, setZielSchonErreicht] = useState(false);

  useEffect(() => {
    const subscription = Accelerometer.addListener(({ x, y }) => {
      setPosition((prev) => {
        let newX = prev.x + x * 30;
        let newY = prev.y + y * -30;

        newX = Math.max(0, Math.min(width - 50, newX));
        newY = Math.max(0, Math.min(height - 50, newY));

        return { x: newX, y: newY };
      });
    });

    Accelerometer.setUpdateInterval(100);
    return () => subscription.remove();
  }, []);

  // Punkt zählen bei Zieltreffer
  useEffect(() => {
    const getroffen =
      position.x > ziel.x &&
      position.x < ziel.x + ziel.size &&
      position.y > ziel.y &&
      position.y < ziel.y + ziel.size;

    if (getroffen && !zielSchonErreicht) {
      setPunkte((prev) => prev + 1);
      setZielSchonErreicht(true);
    } else if (!getroffen) {
      setZielSchonErreicht(false);
    }
  }, [position, ziel.x, ziel.y, ziel.size, zielSchonErreicht]);

  return (
    <GameScreen
      position={position}
      ziel={ziel}
      punkte={punkte}
      spielBeendet={false}
      spielDauer={0}
    />
  );
}
