import React, { useState, useEffect } from 'react';
import { Dimensions } from 'react-native';
import { Accelerometer } from 'expo-sensors';
import GameScreen from './components/GameScreen';

const { width, height } = Dimensions.get('window');


export default function App() {
  const [position, setPosition] = useState({
    x: width / 2 - 25,
    y: height / 2 - 25,
  });

  useEffect(() => {
    const subscription = Accelerometer.addListener(({ x, y }) => {
      setPosition((prev) => {
        let newX = prev.x + x * 30;
        let newY = prev.y + y * -30;

        newX = Math.max(0, Math.min(width - 50, newX));
        newY = Math.max(0, Math.min(height - 50, newY));

        return { x: newX, y: newY };
      });
    });

    Accelerometer.setUpdateInterval(100);

    return () => subscription.remove();
  }, []);

  return (
    <GameScreen
      position={position}
      ziel={{ x: 0, y: 0, size: 0 }}
      punkte={0}
      spielBeendet={false}
      spielDauer={0}
    />
  );
}
