import React, { useState } from 'react';
import { View, Text, Button, StyleSheet } from 'react-native';

export default function App() {
  const [text, setText] = useState('');

  const handleClick = () => {
    setText('Button wurde geklickt!');
  };

  return (
    <View style={styles.container}>
      {/* Neuer statischer Text */}
      <Text style={styles.instructionText}>Drücke den Button!</Text>

      {/* Dynamischer Text, der sich nach einem Klick ändert */}
      <Text style={styles.text}>{text}</Text>

      {/* Button, der den Text ändert */}
      <Button title="Klicken" onPress={handleClick} />
    </View>
  );
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    padding: 20,
  },
  instructionText: { // Neuer Stil für die statische Anweisung
    fontSize: 16,
    marginBottom: 10,
    color: 'gray',
  },
  text: {
    marginBottom: 10,
    fontSize: 18,
  },
});
