import * as Location from 'expo-location';
import { berechneDistanzMeter } from './geo';

export async function frageStandortErlaubnis() {
  const { status } = await Location.requestForegroundPermissionsAsync();
  if (status !== 'granted') {
    alert('Standortzugriff verweigert');
    return false;
  }
  return true;
}

export async function starteTracking(setPositionen, setTrackingObjekt, setDistanz) {
  const erlaubt = await frageStandortErlaubnis();
  if (!erlaubt) return;

  const tracking = await Location.watchPositionAsync(
    {
      accuracy: Location.Accuracy.High,
      timeInterval: 1000,
      distanceInterval: 1,
    },
    (pos) => {
      setPositionen((prev) => {
        const neuePositionen = [...prev, pos.coords];

        // Berechne Zusatzdistanz zwischen letzter und aktueller Position
        if (neuePositionen.length >= 2) {
          const letzte = neuePositionen[neuePositionen.length - 2];
          const aktuelle = neuePositionen[neuePositionen.length - 1];
          const zusatz = berechneDistanzMeter(letzte, aktuelle);
          setDistanz((d) => d + zusatz);
        }

        return neuePositionen;
      });
    }
  );

  setTrackingObjekt(tracking);
}

export function stoppeTracking(trackingObjekt) {
  trackingObjekt?.remove();
}
