export function berechneDistanzMeter(p1, p2) {
  const R = 6371000; // Erdradius in Metern
  const rad = (grad) => (grad * Math.PI) / 180;

  const lat1 = rad(p1.latitude);
  const lat2 = rad(p2.latitude);
  const deltaLat = rad(p2.latitude - p1.latitude);
  const deltaLon = rad(p2.longitude - p1.longitude);

  const a =
    Math.sin(deltaLat / 2) * Math.sin(deltaLat / 2) +
    Math.cos(lat1) * Math.cos(lat2) *
    Math.sin(deltaLon / 2) * Math.sin(deltaLon / 2);

  const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));

  const distanz = R * c;
  return distanz; // in Metern
}
