// logic/fahrtenbuch.js

export function addDummyFahrt(fahrten, setFahrten) {
  const heute = new Date();
  const datum = heute.toISOString().split('T')[0]; // z. B. "2025-05-01"

  // Zufalls-Startzeit (zwischen 6:00 und 20:00 Uhr)
  const stunde = Math.floor(Math.random() * 14) + 6;
  const minute = Math.random() < 0.5 ? "00" : "30";
  const startzeit = `${stunde.toString().padStart(2, "0")}:${minute}`;

  // Dauer zufällig 15–60 Minuten
  const dauer = (Math.floor(Math.random() * 4) + 1) * 15;
  const endStunde = stunde + Math.floor(dauer / 60);
  const endMinute = (parseInt(minute) + (dauer % 60)) % 60;
  const endzeit = `${endStunde.toString().padStart(2, "0")}:${endMinute.toString().padStart(2, "0")}`;

  // Entfernung zufällig zwischen 1 und 50 km (eine Nachkommastelle)
  const entfernung = (Math.random() * 49 + 1).toFixed(1);

  const neueFahrt = {
    id: Date.now(),
    datum,
    startzeit,
    endzeit,
    entfernung,
  };

  setFahrten([...fahrten, neueFahrt]);
}


export function deleteFahrt(id, setFahrten) {
  setFahrten((prevFahrten) => prevFahrten.filter((f) => f.id !== id));
}
