// components/StartStopButton.js
import React, { useState } from 'react';
import { Button, View } from 'react-native';

export default function StartStopButton({ onStart, onStop, läuft }) {
  const handlePress = () => {
    if (läuft) {
      onStop();
    } else {
      onStart();
    }
  };

  return (
    <View style={{ marginBottom: 20 }}>
      <Button
        title={läuft ? 'Aufzeichnung stoppen' : 'Aufzeichnung starten'}
        onPress={handlePress}
      />
    </View>
  );
}


