// components/ManuelleFahrtModal.js
import React from 'react';
import { Modal, View, Text, Button, StyleSheet } from 'react-native';
import ManuelleFahrtForm from './ManuelleFahrtForm';

export default function ManuelleFahrtModal({ visible, onClose, onFahrtSpeichern }) {
  return (
    <Modal visible={visible} animationType="slide" onRequestClose={onClose}>
      <View style={styles.modalContent}>
        <Text style={styles.heading}>Fahrt manuell erfassen</Text>
        <ManuelleFahrtForm
          onFahrtSpeichern={(fahrt) => {
            onFahrtSpeichern(fahrt); // Fahrt speichern
            onClose();               // Modal schließen
          }}
        />
        <Button title="Abbrechen" onPress={onClose} />
      </View>
    </Modal>
  );
}

const styles = StyleSheet.create({
  modalContent: {
    padding: 20,
    paddingTop: 50,
    flex: 1,
    backgroundColor: '#fff',
  },
  heading: {
    fontSize: 20,
    fontWeight: 'bold',
    marginBottom: 10,
  },
});
