// App.js
import React, { useState } from 'react';
import { Button, View, StyleSheet, Text } from 'react-native';
import StartStopButton from './components/StartStopButton';
import FahrtenListe from './components/FahrtenListe';
import { addDummyFahrt, deleteFahrt } from './logic/fahrtenbuch';
import ManuelleFahrtModal from './components/ManuelleFahrtModal';
import { saveFahrt } from './logic/fahrtenSpeichern';
import { starteTracking, stoppeTracking } from './logic/tracking';

export default function App() {
  const [fahrten, setFahrten] = useState([]);
  const [modalVisible, setModalVisible] = useState(false);
  const [positionen, setPositionen] = useState([]);
  const [trackingObjekt, setTrackingObjekt] = useState(null);
  const [startzeit, setStartzeit] = useState(null);
  const [dauer, setDauer] = useState(0); // in Sekunden
  const [distanz, setDistanz] = useState(0); // in Metern
  const [timerId, setTimerId] = useState(null);
  const [aufzeichnungLäuft, setAufzeichnungLäuft] = useState(false); // für Anzeige & Button

  const handleStart = () => {
    setStartzeit(Date.now());
    setDistanz(0);
    setDauer(0);
    setPositionen([]);
    setAufzeichnungLäuft(true);

    // Intervall zur Aktualisierung der Dauer (jede Sekunde)
    const id = setInterval(() => {
      setDauer((prev) => prev + 1);
    }, 1000);
    setTimerId(id);

    starteTracking(setPositionen, setTrackingObjekt, setDistanz);
  };

  const handleStop = () => {
    stoppeTracking(trackingObjekt);
    clearInterval(timerId);
    setTimerId(null);
    setAufzeichnungLäuft(false);

    const jetzt = new Date();
    const fahrt = {
      id: Date.now().toString(),
      typ: 'GPS',
      datum: jetzt.toLocaleDateString('de-DE'),
      startzeit: new Date(startzeit).toLocaleTimeString('de-DE', {
        hour: '2-digit',
        minute: '2-digit',
      }),
      endzeit: jetzt.toLocaleTimeString('de-DE', {
        hour: '2-digit',
        minute: '2-digit',
      }),
      dauer,
      entfernung: (distanz / 1000).toFixed(2),
    };

    setFahrten([...fahrten, fahrt]); // ✅ das hat gefehlt
  };

  const handleDelete = (id) => {
    deleteFahrt(id, setFahrten);
  };

  return (
    <View style={styles.container}>
      <Text style={styles.header}>Fahrtenbuch</Text>
      {aufzeichnungLäuft && (
        <>
          <Text>Dauer: {dauer} Sekunden</Text>
          <Text>Distanz: {distanz.toFixed(1)} Meter</Text>
        </>
      )}

      <Button title="+" onPress={() => setModalVisible(true)} />
      <StartStopButton
        onStart={handleStart}
        onStop={handleStop}
        läuft={aufzeichnungLäuft}
      />

      <FahrtenListe fahrten={fahrten} onDelete={handleDelete} />
      <ManuelleFahrtModal
        visible={modalVisible}
        onClose={() => setModalVisible(false)}
        onFahrtSpeichern={(fahrt) => setFahrten([...fahrten, fahrt])}
      />
    </View>
  );
}

const styles = StyleSheet.create({
  container: {
    padding: 20,
    paddingTop: 60,
  },
  header: {
    fontSize: 24,
    marginBottom: 20,
  },
});
