import { getDistance } from 'geolib';

function formatTime(date) {
  return date.toLocaleTimeString('de-DE', { hour: '2-digit', minute: '2-digit' });
}

export function saveFahrt(positionen, setFahrten) {
  if (positionen.length < 2) {
    alert('Nicht genug GPS-Daten zur Berechnung.');
    return;
  }

  const start = positionen[0];
  const end = positionen[positionen.length - 1];

  const entfernungMeter = getDistance(start, end);
  const entfernungKm = (entfernungMeter / 1000).toFixed(2);

  const jetzt = new Date();
  const neueFahrt = {
    id: Date.now(),
    datum: jetzt.toLocaleDateString('de-DE'),
    startzeit: formatTime(jetzt),
    endzeit: formatTime(jetzt),
    entfernung: entfernungKm
  };

  setFahrten((prev) => [...prev, neueFahrt]);
}
