// components/FahrtenListe.js
import React from 'react';
import { View, Text, FlatList, Button, StyleSheet } from 'react-native';

export default function FahrtenListe({ fahrten, onDelete }) {
  const renderItem = ({ item }) => (
    <View style={styles.fahrtContainer}>
     <Text style={styles.text}>
  {item.datum}: {item.startzeit} – {item.endzeit} | {item.entfernung} km
</Text>

      <Button title="Löschen" onPress={() => onDelete(item.id)} />
    </View>
  );

  return (
    <View>
      <Text style={styles.heading}>Fahrten</Text>
      <FlatList
        data={fahrten}
        renderItem={renderItem}
        keyExtractor={(item) => item.id.toString()}
      />
    </View>
  );
}

const styles = StyleSheet.create({
  heading: {
    fontSize: 18,
    fontWeight: 'bold',
    marginBottom: 10,
  },
  fahrtContainer: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginBottom: 10,
    paddingVertical: 8,
    borderBottomWidth: 1,
    borderColor: '#ccc',
  },
  text: {
    fontSize: 16,
  },
});
