// App.js
import React, { useState } from 'react';
import { Button, View, StyleSheet, Text } from 'react-native';
import StartStopButton from './components/StartStopButton';
import FahrtenListe from './components/FahrtenListe';
import { addDummyFahrt, deleteFahrt } from './logic/fahrtenbuch';
import ManuelleFahrtModal from './components/ManuelleFahrtModal';
import { saveFahrt } from './logic/fahrtenSpeichern';



export default function App() {
  const [fahrten, setFahrten] = useState([]);
  const [modalVisible, setModalVisible] = useState(false);

  const handleStartStop = () => {
    addDummyFahrt(fahrten, setFahrten);
  };

  const handleDelete = (id) => {
    deleteFahrt(id, setFahrten);
  };

  return (
    <View style={styles.container}>
      <Text style={styles.header}>Fahrtenbuch</Text>
      <Button title="+" onPress={() => setModalVisible(true)} />
      <StartStopButton onStartStop={handleStartStop} />
      <FahrtenListe fahrten={fahrten} onDelete={handleDelete} />
      <ManuelleFahrtModal
        visible={modalVisible}
        onClose={() => setModalVisible(false)}
        onFahrtSpeichern={(fahrt) => setFahrten([...fahrten, fahrt])}
      />
    </View>
  );
}

const styles = StyleSheet.create({
  container: {
    padding: 20,
    paddingTop: 60,
  },
  header: {
    fontSize: 24,
    marginBottom: 20,
  },
});
