// components/StartStopButton.js
import React, { useState } from 'react';
import { Button, View } from 'react-native';

export default function StartStopButton({ onStartStop }) {
  const [aufzeichnungLäuft, setAufzeichnungLäuft] = useState(false);

  const handlePress = () => {
    setAufzeichnungLäuft(!aufzeichnungLäuft);
    if (aufzeichnungLäuft) {
      onStartStop(); // Nur beim Stoppen → Dummy-Fahrt hinzufügen
    }
  };

  return (
    <View style={{ marginBottom: 20 }}>
      <Button
        title={
          aufzeichnungLäuft ? 'Aufzeichnung stoppen' : 'Aufzeichnung starten'
        }
        onPress={handlePress}
      />
    </View>
  );
}
