// components/ManuelleFahrtForm.js
import React, { useState } from 'react';
import { View, Text, TextInput, Button, StyleSheet } from 'react-native';

export default function ManuelleFahrtForm({ onFahrtSpeichern }) {
  const [datum, setDatum] = useState(new Date().toLocaleDateString("de-DE"));
  const [startzeit, setStartzeit] = useState('');
  const [endzeit, setEndzeit] = useState('');
  const [entfernung, setEntfernung] = useState('');

  const handleSubmit = () => {
    if (!startzeit || !endzeit || !entfernung) {
      alert('Bitte alle Felder ausfüllen.');
      return;
    }

    const neueFahrt = {
      id: Date.now(),
      datum,
      startzeit,
      endzeit,
      entfernung,
    };

    onFahrtSpeichern(neueFahrt);

    // Eingaben zurücksetzen
    setStartzeit('');
    setEndzeit('');
    setEntfernung('');
  };

  return (
    <View style={styles.container}>
      <Text style={styles.heading}>Fahrt manuell erfassen</Text>
      <TextInput
        style={styles.input}
        placeholder="Datum (z. B. 03.05.2025)"
        value={datum}
        onChangeText={setDatum}
      />
      <TextInput
        style={styles.input}
        placeholder="Startzeit (z. B. 08:30)"
        value={startzeit}
        onChangeText={setStartzeit}
      />
      <TextInput
        style={styles.input}
        placeholder="Endzeit (z. B. 09:00)"
        value={endzeit}
        onChangeText={setEndzeit}
      />
      <TextInput
        style={styles.input}
        placeholder="Entfernung in km (z. B. 4.2)"
        value={entfernung}
        onChangeText={setEntfernung}
        keyboardType="decimal-pad"
      />
      <Button title="Fahrt hinzufügen" onPress={handleSubmit} />
    </View>
  );
}

const styles = StyleSheet.create({
  container: {
    marginBottom: 30,
    padding: 10,
    backgroundColor: '#f4f4f4',
    borderRadius: 8,
  },
  heading: {
    fontSize: 16,
    fontWeight: 'bold',
    marginBottom: 10,
  },
  input: {
    backgroundColor: 'white',
    padding: 10,
    marginBottom: 8,
    borderWidth: 1,
    borderColor: '#ccc',
    borderRadius: 4,
  },
});
