// App.js
import React, { useState } from 'react';
import { View, StyleSheet, Text } from 'react-native';
import StartStopButton from './components/StartStopButton';
import FahrtenListe from './components/FahrtenListe';
import { addDummyFahrt, deleteFahrt } from './logic/fahrtenbuch';

export default function App() {
  const [fahrten, setFahrten] = useState([]);

  const handleStartStop = () => {
    addDummyFahrt(fahrten, setFahrten);
  };

  const handleDelete = (id) => {
    deleteFahrt(id, setFahrten);
  };

  return (
    <View style={styles.container}>
      <Text style={styles.header}>Fahrtenbuch</Text>
      <StartStopButton onStartStop={handleStartStop} />
      <FahrtenListe fahrten={fahrten} onDelete={handleDelete} />
    </View>
  );
}

const styles = StyleSheet.create({
  container: {
    padding: 20,
    paddingTop: 60,
  },
  header: {
    fontSize: 24,
    marginBottom: 20,
  },
});
