import React from 'react';
import { View, Text, StyleSheet } from 'react-native';

export default function TrafficLight({ light }) {
  const getTextColor = () => {
    switch (light) {
      case 'Rot':
        return 'red';
      case 'Gelb':
        return 'orange';
      case 'Grün':
        return 'green';
      default:
        return 'black';
    }
  };

  return (
    <View style={styles.container}>
      <Text style={[styles.text, { color: getTextColor() }]}>{light}</Text>
      <View
        style={[
          styles.circle,
          { backgroundColor: light.toLowerCase() },
        ]}
      />
    </View>
  );
}

const styles = StyleSheet.create({
  container: { alignItems: 'center', marginBottom: 20 },
  text: { fontSize: 24 },
  circle: { width: 100, height: 100, borderRadius: 50, marginTop: 10 },
});
