import React, { useState } from 'react';
import { View, StyleSheet } from 'react-native';
import TrafficLight from './components/TrafficLight';
import ControlButton from './components/ControlButton';

export default function App() {
  const [light, setLight] = useState('Rot');

  const nextLight = () => {
    if (light === 'Rot') setLight('Gelb');
    else if (light === 'Gelb') setLight('Grün');
    else setLight('Rot');
  };

  return (
    <View style={styles.container}>
      <TrafficLight light={light} />
      <ControlButton onPress={nextLight} />
    </View>
  );
}

const styles = StyleSheet.create({
  container: { flex: 1, justifyContent: 'center', alignItems: 'center' },
});
