import React, { useState } from 'react';
import { View, Text, Button, StyleSheet } from 'react-native';

export default function App() {
  const [light, setLight] = useState('Rot');

  const nextLight = () => {
    if (light === 'Rot') setLight('Gelb');
    else if (light === 'Gelb') setLight('Grün');
    else setLight('Rot');
  };

  const getTextColor = () => {
    switch (light) {
      case 'Rot':
        return 'red';
      case 'Gelb':
        return 'orange';
      case 'Grün':
        return 'green';
      default:
        return 'black';
    }
  };

  return (
    <View style={styles.container}>
      <Text style={[styles.text, { color: getTextColor() }]}>{light}</Text>
      <View style={[styles.circle, { backgroundColor: light.toLowerCase() }]} />
      <Button title="Wechseln" onPress={nextLight} />
    </View>
  );
}

const styles = StyleSheet.create({
  container: { flex: 1, justifyContent: 'center', alignItems: 'center' },
  text: { fontSize: 24, marginBottom: 10 },
  circle: { width: 100, height: 100, borderRadius: 50, marginVertical: 20 },
});
