import React from 'react';
import { View, Text, StyleSheet } from 'react-native';
import MaterialCommunityIcons from 'react-native-vector-icons/MaterialCommunityIcons';

export default function LightStatus({ isOn }) {
  return (
    <View style={styles.container}>
      <Text style={styles.text}>{isOn ? 'Licht an' : 'Licht aus'}</Text>
      <MaterialCommunityIcons
        name={isOn ? 'lightbulb-on' : 'lightbulb-off'}
        size={100}
        color={isOn ? 'yellow' : 'black'}
      />
    </View>
  );
}

const styles = StyleSheet.create({
  container: { alignItems: 'center' },
  text: { fontSize: 24, marginBottom: 10 },
});
