import React, { useState } from 'react';
import { View, StyleSheet } from 'react-native';
import LightStatus from './components/LightStatus';
import LightSwitch from './components/LightSwitch';

export default function App() {
  const [isOn, setIsOn] = useState(false);

  return (
    <View style={styles.container}>
      <LightStatus isOn={isOn} />
      <LightSwitch onPress={() => setIsOn(!isOn)} />
    </View>
  );
}

const styles = StyleSheet.create({
  container: { flex: 1, justifyContent: 'center', alignItems: 'center' },
});
