import React, { useState } from 'react';
import { View, Text, Button, StyleSheet } from 'react-native';
import MaterialCommunityIcons from 'react-native-vector-icons/MaterialCommunityIcons';

export default function App() {
  const [isOn, setIsOn] = useState(false);

  return (
    <View style={styles.container}>
      <Text style={styles.text}>{isOn ? 'Licht an' : 'Licht aus'}</Text>
      <MaterialCommunityIcons
        name={isOn ? 'lightbulb-on' : 'lightbulb-off'}
        size={100}
        color={isOn ? 'yellow' : 'black'}
      />
      <Button title="Schalten" onPress={() => setIsOn(!isOn)} />
    </View>
  );
}

const styles = StyleSheet.create({
  container: { flex: 1, justifyContent: 'center', alignItems: 'center' },
  text: { fontSize: 24, marginBottom: 10 },
});
