import React, { useState } from 'react';
import { View, Text, TextInput, StyleSheet } from 'react-native';

export default function App() {
  const [name, setName] = useState('');

  return (
    <View style={styles.container}>
      <Text style={styles.text}>Hallo, {name || 'Gib deinen Namen ein!'}</Text>
      <TextInput
        style={styles.input}
        placeholder="Name"
        onChangeText={setName}
      />
    </View>
  );
}

const styles = StyleSheet.create({
  container: { flex: 1, justifyContent: 'center', alignItems: 'center' },
  text: { fontSize: 24, marginBottom: 10 },
  input: { borderWidth: 1, padding: 8, width: 200 },
});
