import { useState } from 'react';

export default function useQuotes() {
  const [quotes, setQuotes] = useState([
    "Glaube, dass du es kannst, und du bist schon auf halbem Weg.",
    "Der einzige Weg, großartige Arbeit zu leisten, ist, zu lieben, was man tut.",
    "Du bist stärker, als du denkst.",
  ]);

  const addQuote = (newQuote) => {
    if (newQuote.trim() !== "") {
      setQuotes([...quotes, newQuote]);
    }
  };

  const getRandomQuote = () => {
    if (quotes.length === 0) return "Keine Zitate verfügbar!";
    const randomIndex = Math.floor(Math.random() * quotes.length);
    return quotes[randomIndex];
  };

  return { quotes, addQuote, getRandomQuote };
}
