import React from 'react';
import { FlatList, Text, StyleSheet } from 'react-native';

export default function QuoteList({ quotes }) {
  return (
    <FlatList
      data={quotes}
      keyExtractor={(item, index) => index.toString()}
      renderItem={({ item }) => <Text style={styles.listItem}>- {item}</Text>}
    />
  );
}

const styles = StyleSheet.create({
  listItem: {
    fontSize: 16,
    marginBottom: 5,
  },
});
