import React from 'react';
import { View, StyleSheet } from 'react-native';
import Header from './components/Header';
import QuoteDisplay from './components/QuoteDisplay';
import QuoteInput from './components/QuoteInput';
import QuoteList from './components/QuoteList';
import useQuotes from './hooks/useQuotes';

export default function App() {
  const { quotes, addQuote, getRandomQuote } = useQuotes();

  return (
    <View style={styles.container}>
      <Header title="Motivations-App" />
      <QuoteDisplay quote={getRandomQuote()} />
      <QuoteInput onAddQuote={addQuote} />
      <QuoteList quotes={quotes} />
    </View>
  );
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
    padding: 20,
    backgroundColor: '#f0f8ff',
  },
});
