import React, { useState } from 'react';
import { View, TextInput, Button, StyleSheet } from 'react-native';

export default function QuoteInput({ onAddQuote }) {
  const [newQuote, setNewQuote] = useState('');

  const handleAddQuote = () => {
    if (newQuote.trim().length > 0) {
      onAddQuote(newQuote);
      setNewQuote('');
    }
  };

  return (
    <View style={styles.container}>
      <TextInput
        style={styles.input}
        placeholder="Eigenes Zitat hinzufügen"
        value={newQuote}
        onChangeText={setNewQuote}
      />
      <Button title="Zitat hinzufügen" onPress={handleAddQuote} />
    </View>
  );
}

const styles = StyleSheet.create({
  container: {
    marginVertical: 10,
  },
  input: {
    borderColor: '#ccc',
    borderWidth: 1,
    borderRadius: 5,
    padding: 10,
    marginBottom: 10,
  },
});