import React, { useState } from 'react';
import {
  View,
  Text,
  TextInput,
  Button,
  StyleSheet,
  FlatList,
  SafeAreaView,
} from 'react-native';

export default function App() {
  const [quotes, setQuotes] = useState([
    'Glaube, dass du es kannst, und du bist schon auf halbem Weg.',
    'Der einzige Weg, großartige Arbeit zu leisten, ist, zu lieben, was man tut.',
    'Du bist stärker, als du denkst.',
    'Die Axt im Haus erspart den Zimmermann.',
  ]);
  const [newQuote, setNewQuote] = useState('');

  const addQuote = () => {
    if (newQuote.trim().length > 0) {
      setQuotes([...quotes, newQuote]);
      setNewQuote('');
    }
  };

  return (
    <SafeAreaView style={styles.safeContainer}>
      <View style={styles.container}>
        <Text style={styles.header}>Motivations-App</Text>
        <Text style={styles.quote}>{quotes[0]}</Text>

        <TextInput
          style={styles.input}
          placeholder="Eigenes Zitat hinzufügen"
          value={newQuote}
          onChangeText={setNewQuote}
        />
        <Button title="Add" onPress={addQuote} />

        <Text style={styles.subHeader}>Alle Zitate:</Text>
        <FlatList
          data={quotes}
          keyExtractor={(item, index) => index.toString()}
          renderItem={({ item }) => (
            <Text style={styles.listItem}>- {item}</Text>
          )}
        />
      </View>
    </SafeAreaView>
  );



  
}





const styles = StyleSheet.create({
  safeContainer: {
    flex: 1,
    backgroundColor: '#f0f8ff',
  },
  container: {
    flex: 1,
    padding: 20,
  },
  header: {
    fontSize: 34,
    fontWeight: 'bold',
    textAlign: 'center',
    marginBottom: 20,
  },
  quote: {
    fontSize: 18,
    fontStyle: 'italic',    
    fontWeight: 'bold',
    textAlign: 'center',
    marginBottom: 20,
  },
  input: {
    borderColor: '#ccc',
    borderWidth: 1,
    borderRadius: 5,
    padding: 10,
    marginBottom: 10,
  },
  subHeader: {
    fontSize: 18,
    marginTop: 20,
    marginBottom: 10,
  },
  listItem: {
    fontSize: 16,
    marginBottom: 5,
  },
});
