import React, { useState } from 'react';
import {
  StyleSheet,
  View,
  Button,
  Text,
  TouchableOpacity,
  SafeAreaView,
  Image,
} from 'react-native';
import { FontAwesome, MaterialIcons } from '@expo/vector-icons';

const App = () => {
  const [currentDate, setCurrentDate] = useState(new Date());
  const [isRecording, setIsRecording] = useState(false); // Zustand für die Aufzeichnung

  // Berechnet die Anzahl der Sterne (aktuell statisch als Platzhalter)
  const renderStars = () => {
    const filledStars = 3; // Beispiel: 3 gefüllte Sterne
    return [...Array(5)].map((_, index) => (
      <FontAwesome
        key={index}
        name={index < filledStars ? 'star' : 'star-o'}
        size={24}
        color={index < filledStars ? 'gold' : 'black'}
      />
    ));
  };

  // Funktion zum Umschalten der Aufzeichnung
  const toggleRecording = () => {
    setIsRecording((prev) => !prev);
  };

  return (
    <SafeAreaView style={styles.container}>
      {/* Datum und Navigation */}
      <View style={styles.dateContainer}>
        <TouchableOpacity
          onPress={() =>
            setCurrentDate(
              new Date(currentDate.setDate(currentDate.getDate() - 1))
            )
          }>
          <MaterialIcons name="arrow-back-ios" size={24} color="black" />
        </TouchableOpacity>
        <Text style={styles.dateText}>{currentDate.toDateString()}</Text>
        <TouchableOpacity
          onPress={() =>
            setCurrentDate(
              new Date(currentDate.setDate(currentDate.getDate() + 1))
            )
          }>
          <MaterialIcons name="arrow-forward-ios" size={24} color="black" />
        </TouchableOpacity>
      </View>

      {/* Sternanzeige */}
      <View style={styles.starsContainer}>{renderStars()}</View>

      {/* Karten-Platzhalter */}
      <View style={styles.mapContainer}>
        <Image
          source={require('./assets/map.PNG')} // Passe den Pfad an, falls nötig
          style={styles.map}
          resizeMode="cover"
        />
      </View>

      {/* Dauer und Entfernung (Platzhalter) */}
      <View style={styles.infoContainer}>
        <Text style={styles.info}>Dauer: 0 Minuten 0 Sekunden</Text>
        <Text style={styles.info}>Entfernung: 0.00 km</Text>
      </View>

      {/* Aktivitäten und Buttons */}
      <View style={styles.activitiesContainer}>
        <Text style={styles.activitiesHeader}>Aktivitäten:</Text>
        <View style={styles.iconGroup}>
          <TouchableOpacity>
            <MaterialIcons name="work-history" size={24} color="black" />
          </TouchableOpacity>
          <TouchableOpacity>
            <MaterialIcons name="show-chart" size={24} color="black" />
          </TouchableOpacity>
          <TouchableOpacity>
            <MaterialIcons name="add" size={24} color="black" />
          </TouchableOpacity>
        </View>
      </View>

      {/* Button "Aufzeichnung starten"/"Aufzeichnung stoppen" */}
      <View style={styles.buttonContainer}>
        <Button
          title={isRecording ? 'Aufzeichnung stoppen' : 'Aufzeichnung starten'}
          onPress={toggleRecording}
        />
      </View>
    </SafeAreaView>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: '#f0f0f0',
  },
  dateContainer: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    padding: 10,
    backgroundColor: 'white',
    elevation: 5,
  },
  dateText: {
    fontSize: 18,
    fontWeight: 'bold',
  },
  starsContainer: {
    flexDirection: 'row',
    justifyContent: 'center',
    padding: 10,
    backgroundColor: 'white',
  },
  mapContainer: {
    height: '30%',
    backgroundColor: '#e0e0e0',
    justifyContent: 'center',
    alignItems: 'center',
  },
  map: {
    width: '100%',
    height: '100%',
  },
  infoContainer: {
    padding: 10,
    backgroundColor: 'white',
    elevation: 5,
    margin: 10,
    borderRadius: 10,
  },
  info: {
    fontSize: 16,
    textAlign: 'center',
    marginVertical: 5,
  },
  activitiesContainer: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    padding: 10,
    backgroundColor: 'white',
  },
  activitiesHeader: {
    fontSize: 16,
    fontWeight: 'bold',
  },
  iconGroup: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-evenly',
    width: 120,
  },
  buttonContainer: {
    position: 'absolute',
    bottom: 20,
    left: 20,
    right: 20,
    backgroundColor: 'white',
    padding: 10,
    borderRadius: 10,
    elevation: 5,
  },
});

export default App;
